<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 24.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Neues Benutzerkonto');
requireLogin();
requireRole('Administrator');

// Benutzerkonto erstellen
if (isset($_POST['createAccount'])) {

    // Datenbankverbindung
    initializeDatabaseConnection();

    // Prüfen ob Bereits ein Benutzerkonto mit dem Benutzernamen existiert
    $sql = "SELECT COUNT(*) FROM Accounts WHERE Username = :username";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':username', $_POST['accountUsername']);
    $stmt->execute();

    $isUsernameAvailable = $stmt->fetchColumn();

    if (!$isUsernameAvailable) {

        // Passwort mit bcrypt verschlüsseln
        $accountPassword = password_hash($_POST['accountPassword'], PASSWORD_DEFAULT);

        // Benutzerkonto in Datenbank eintragen
        $stmt = $pdo->prepare("INSERT INTO Accounts (Username, Password, Type, Role, DisplayName) VALUES (:username, :password, 'local', :role, :displayname)");
        $stmt->bindParam(':username', $_POST['accountUsername']);
        $stmt->bindParam(':password', $accountPassword);
        $stmt->bindParam(':role', $_POST['accountRole']);
        $stmt->bindParam(':displayname', $_POST['accountDisplayName']);
        $stmt->execute();

        // AuditLog: Eintrag erstellen
        addAuditLog($_SESSION['Username'], 'Benutzerkonto', 'Benutzerkonto "' . $_POST['accountUsername'] . '" erstellt');

        // Alert: Erfolgsmeldung
        sweetAlert('', 'Das Benutzerkonto wurde erstellt!', 'success');

    } else {

        // Alert: Fehlermeldung
        sweetAlert('', 'Das Benutzerkonto existiert bereits!', 'error');

    }


}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<form action="" method="post" id="newAccount">

    <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
        <div>
            <h4 class="mb-3 mb-md-0">Neues Benutzerkonto</h4>
            <span class="text-secondary">Administration</span>
        </div>
        <div class="d-flex align-items-center flex-wrap text-nowrap">

            <button class="btn btn-primary btn-icon-text me-2" type="submit" name="createAccount">
                <i class="btn-icon-prepend" data-feather="user-plus"></i>
                Hinzufügen
            </button>

            <a href="/administration/accounts" class="btn btn-secondary btn-icon mb-2 mb-md-0">
                <i data-feather="corner-up-left"></i>
            </a>
        </div>
    </div>

    <div class="row">

        <div class="col-lg-12 col-xl-8 grid-margin">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Benutzerdaten
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="accountUsername" class="form-label">Benutzername</label>
                        <input id="accountUsername" name="accountUsername" class="form-control" type="text">
                    </div>
                    <div class="mb-3">
                        <label for="accountDisplayName" class="form-label">Vollständiger Name</label>
                        <input id="accountDisplayName" class="form-control" name="accountDisplayName" type="text">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Rolle</label>
                        <select class="js-example-basic-single form-select form-control" name="accountRole"
                            data-width="100%">
                            <option value="Bediener" selected>Bediener</option>
                            <option value="Bearbeiter">Bearbeiter</option>
                            <option value="Auswerter">Auswerter</option>
                            <option value="Auditor">Auditor</option>
                            <option value="Administrator">Administrator</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-12 col-xl-4 grid-margin">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    Passwort
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="accountPassword" class="form-label">Passwort</label>
                        <input id="accountPassword" class="form-control" name="accountPassword" type="password">
                    </div>
                </div>
            </div>
        </div>

    </div>

</form>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>